//
//  $Id: AHKUniquelyNumberedArrayController.m 98 2009-06-12 17:01:44Z fujidana $
//  Copyright (c) 2005-2009 Fujidana All rights reserved.
//
//
//  BookmarkController.m
//  BookmarkUtility
//
//  Created by raktajino on Sun Jun 20 2004.
//  Copyright (c) 2004 raktajino. All rights reserved.
//
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "AHKUniquelyNumberedArrayController.h"
#import "AHKNumbering.h"


@implementation AHKUniquelyNumberedArrayController


#pragma mark override methods

- (id)newObject
{
	int index = [self unusedNumber];
	if (index == NSNotFound)
	{
		return nil;
	}
	
	id object = [super newObject];
	if (object != nil)
	{
		[object setNumber:index];
	}
	return object;
}

- (BOOL)canAdd
{
	if ([[self content] count] >= [self capacity])
	{
		return NO;
	}
	return [super canAdd];
}

- (BOOL)canInsert
{
	if ([[self content] count] >= [self capacity])
	{
		return NO;
	}
	return [super canInsert];
}

#pragma mark accessor methods
- (int)maxValue
{
	return maxValue;
}

- (void)setMaxValue:(int)value
{
	maxValue = value;
}

- (int)minValue
{
	return minValue;
}

- (void)setMinValue:(int)value
{
	minValue = value;
}

- (int)capacity
{
	if (maxValue >= minValue)
	{
		return maxValue - minValue + 1;
	}
	else
{
		return 0;
	}
}
#pragma mark other methods
- (int)unusedNumberAboveNumber:(int)lowestNumber exceptObjects:(NSArray *)exceptedObjects
{
	NSSortDescriptor *sortDescriptor  = [[[NSSortDescriptor alloc] initWithKey:@"number" ascending:YES] autorelease];
	NSArray          *sortDescriptors = [NSArray arrayWithObject:sortDescriptor];
	NSMutableArray   *contentArray    = [[[self content] mutableCopy] autorelease];
	if (exceptedObjects != nil)
	{
		[contentArray removeObjectsInArray:exceptedObjects]; 
	}
	NSArray           *sortedArray  = [contentArray sortedArrayUsingDescriptors:sortDescriptors];
	id <AHKNumbering> object;
	int               currentNumber = lowestNumber;
	int               i;
	int               n             = [sortedArray count];
	
	// -- set 'n' to the index of the content array which becomes greater than or equal to 'lowestNumber' --
	for (i = 0; i < [sortedArray count]; i++)
	{
		object = [sortedArray objectAtIndex:i];
		if ([object number] >= lowestNumber)
		{
			n = i;
			break;
		}
	}
	
	// return the lowest unused number between 'n'th card's number ('lowestNumber') and the largest number in existence, if it exists.
	for (i = n; i < [sortedArray count]; i++)
	{
		object = [sortedArray objectAtIndex:i];
		if ([object number] != currentNumber)
		{
			return currentNumber;
		}
		currentNumber++;
	}
	
	// return the lowest unused number above the largest number in existence, if it exists.
	if (currentNumber <= [self maxValue])
	{
		return currentNumber;
	}
	
	currentNumber = [self minValue];
	
	// return the lowest unused number below 'n-1'th card's number, if it exists.
	for (i = [self minValue]; i < n; i++)
	{
		object = [sortedArray objectAtIndex:i];
		if ([object number] != currentNumber)
		{
			return currentNumber;
		}
		currentNumber++;
	}
	
	// return the lowest numbmer between 'n-1'th card's number and 'n'th card's number ('lowestNumber'), if it exists.
	if (currentNumber != lowestNumber)
	{
		return currentNumber;
	}
	
	// fail to find an unused memory number.
	return NSNotFound;
}

// return the smallest unused number above the number of selected card. return NSNotFound if an unused number is not found.
- (int)unusedNumber
{
	int	number = [[[self selectedObjects] lastObject] number];
	return [self unusedNumberAboveNumber:number exceptObjects:nil];
}

- (BOOL)containsNumber:(int)number exceptObject:(id <AHKNumbering>)exceptedObject
{
	id <AHKNumbering> object;
	NSEnumerator *enumerator = [[self content] objectEnumerator];
	while (object = [enumerator nextObject])
	{
		if ([object number] == number && object != exceptedObject)
		{
			return YES;
		}
	}
	return NO;
}

@end
